#!/bin/bash

echo "🧹 Resetting HeyRaven app cache on macOS (no sudo required)..."
echo ""

# Kill the app if running
echo "Stopping HeyRaven if running..."
pkill -f HeyRaven || true
killall HeyRaven 2>/dev/null || true
killall Electron 2>/dev/null || true

# Clear per-user icon services caches (no sudo needed)
echo "Clearing user icon cache..."
rm -rf ~/Library/Caches/com.apple.iconservices.store 2>/dev/null || true
rm -rf ~/Library/Caches/com.apple.iconservices* 2>/dev/null || true
rm -rf ~/Library/Caches/com.apple.dock.iconcache 2>/dev/null || true

# Kill icon services to force reload (they auto-restart)
echo "Restarting icon services..."
killall -KILL iconservicesd 2>/dev/null || true
killall -KILL IconServicesAgent 2>/dev/null || true

# Clear Launch Services database (no sudo needed for user domain)
echo "Rebuilding Launch Services database..."
/System/Library/Frameworks/CoreServices.framework/Frameworks/LaunchServices.framework/Support/lsregister -kill -r -domain local -domain system -domain user

# Remove app preferences
echo "Removing app preferences..."
defaults delete app.heyraven.desktop 2>/dev/null || true
defaults delete com.electron.heyraven-electron 2>/dev/null || true
defaults delete com.electron.hey-raven-electron 2>/dev/null || true

# Clear saved application state
echo "Clearing saved application state..."
rm -rf ~/Library/Saved\ Application\ State/app.heyraven.desktop.savedState 2>/dev/null || true
rm -rf ~/Library/Saved\ Application\ State/com.electron.heyraven-electron.savedState 2>/dev/null || true
rm -rf ~/Library/Saved\ Application\ State/com.electron.hey-raven-electron.savedState 2>/dev/null || true

# Clear per-user Dock databases (optional - might reset dock layout)
# Uncomment if you want more aggressive reset:
# echo "Clearing Dock databases..."
# rm -f ~/Library/Application\ Support/Dock/*.db 2>/dev/null || true

# Re-register the app if found
echo "Re-registering HeyRaven app..."
if [ -d "/Applications/HeyRaven.app" ]; then
    /System/Library/Frameworks/CoreServices.framework/Frameworks/LaunchServices.framework/Support/lsregister -f /Applications/HeyRaven.app 2>/dev/null || true
    echo "  ✓ App re-registered"
fi

# Touch Applications folder to refresh
echo "Refreshing Applications folder..."
touch /Applications/HeyRaven.app 2>/dev/null || true
touch ~/Applications/* 2>/dev/null || true

# Restart Dock to apply changes
echo "Restarting Dock..."
killall Dock

# Clear Quick Look cache as well
echo "Clearing Quick Look cache..."
qlmanage -r cache 2>/dev/null || true

echo ""
echo "✅ Cache cleared successfully (no sudo required)!"
echo ""
echo "📱 The Dock is restarting..."
echo ""
echo "🚀 Please wait 5-10 seconds, then start HeyRaven again."
echo "   The app should now appear in the Dock."
echo ""
echo "If the dock icon still doesn't appear:"
echo "  1. Close HeyRaven completely"
echo "  2. Run this script again"
echo "  3. Wait 10 seconds"
echo "  4. Open HeyRaven from Applications folder"
echo ""
echo "For persistent issues:"
echo "  - Log out and log back in to your Mac"
echo "  - Or restart your Mac (most thorough)"
echo ""
echo "Press any key to exit..."
read -n 1 -s